/*
 * Decompiled with CFR 0.152.
 */
package com.eeeab.eeeabsmobs.client.model.entity;

import com.eeeab.eeeabsmobs.client.model.entity.EEAdvancedEntityModel;
import com.eeeab.eeeabsmobs.sever.entity.impl.EEEABMobLibrary;
import com.eeeab.eeeabsmobs.sever.entity.impl.immortal.EntityImmortal;
import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.client.model.AdvancedModelBox;
import com.github.alexthe666.citadel.client.model.ModelAnimator;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class ModelImmortalBase<T extends EntityImmortal>
extends EEAdvancedEntityModel<T> {
    protected AdvancedModelBox root;
    protected AdvancedModelBox upper;
    protected AdvancedModelBox lower;
    protected AdvancedModelBox head;
    protected AdvancedModelBox body;
    protected AdvancedModelBox leftArm;
    protected AdvancedModelBox rightArm;
    protected AdvancedModelBox leftLeg;
    protected AdvancedModelBox rightLeg;
    protected ModelAnimator animator;

    @Override
    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float delta = ageInTicks - (float)((EntityImmortal)entity).f_19797_;
        float frame = (float)((EntityImmortal)entity).frame + delta;
        this.spawnAnimate(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, frame);
        this.setRotationAnglesSpawn(entity, frame);
    }

    protected void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float frame) {
    }

    protected void spawnAnimate(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float delta) {
        this.resetToDefaultPose();
        this.animator.update(entity);
        if (this.animator.setAnimation(this.getSpawnAnimation())) {
            this.animator.startKeyframe(0);
            this.animator.move(this.root, 0.0f, 35.0f, 0.0f);
            this.animator.rotate(this.head, ModelImmortalBase.toRadians(-50.0), 0.0f, 0.0f);
            this.animator.rotate(this.leftArm, ModelImmortalBase.toRadians(this.handsOffset()), 0.0f, 0.0f);
            this.animator.rotate(this.rightArm, ModelImmortalBase.toRadians(this.handsOffset()), 0.0f, 0.0f);
            this.animator.endKeyframe();
            this.animator.startKeyframe(35);
            this.animator.move(this.root, 0.0f, 0.0f, 0.0f);
            this.animator.rotate(this.head, ModelImmortalBase.toRadians(-40.0), 0.0f, 0.0f);
            this.animator.rotate(this.leftArm, ModelImmortalBase.toRadians(this.handsOffset()), 0.0f, 0.0f);
            this.animator.rotate(this.rightArm, ModelImmortalBase.toRadians(this.handsOffset()), 0.0f, 0.0f);
            this.animator.endKeyframe();
            this.animator.resetKeyframe(5);
        }
        this.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, delta);
    }

    public void setRotationAnglesSpawn(T entityIn, float frame) {
        Animation spawnAnimation = this.getSpawnAnimation();
        if (((EEEABMobLibrary)((Object)entityIn)).getAnimation() == spawnAnimation && ((EEEABMobLibrary)((Object)entityIn)).getAnimationTick() < spawnAnimation.getDuration()) {
            this.walk(this.rightArm, 0.5f, 0.5f, true, 1.0f, 0.0f, frame, 1.0f);
            this.walk(this.leftArm, 0.5f, 0.5f, false, 1.0f, 0.0f, frame, 1.0f);
        }
    }

    protected double handsOffset() {
        return -180.0;
    }

    protected abstract Animation getSpawnAnimation();
}

